/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.datasync.web;

import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import dev.upcraft.datasync.DataSyncMod;
import dev.upcraft.datasync.util.ModHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import oshi.SystemInfo;
import oshi.software.os.OperatingSystem;

public class HttpUtil {
    private static final Gson GSON = new Gson();
    private static final ExecutorService BACKGROUND_EXECUTOR = Executors.newCachedThreadPool(r -> {
        Thread t = new Thread(r, "[DataSync] Background Data Fetcher");
        t.setDaemon(true);
        return t;
    });
    private static final Supplier<HttpClient> httpClient = Suppliers.memoize(() -> HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).executor(BACKGROUND_EXECUTOR).build());

    public static HttpClient getClient() {
        return httpClient.get();
    }

    public static String getUserAgentString() {
        ModMetadata meta = ModHelper.getMeta("datasync_minecraft");
        ModMetadata gameMeta = ModHelper.getGameMeta();
        String loader = HttpUtil.buildLoaderUAString();
        String system = HttpUtil.buildSystemUAString();
        return String.format("%s/%s (%s) %s/%s (%s)", meta.getName(), meta.getVersion(), loader, gameMeta.getName(), gameMeta.getVersion(), system);
    }

    public static String buildLoaderUAString() {
        ModMetadata meta = ModHelper.getLoaderMeta();
        StringBuilder sb = new StringBuilder();
        sb.append(meta.getName()).append('/').append(meta.getVersion());
        if (ModHelper.isLoaded("connectormod")) {
            sb.append("; ");
            ModMetadata connectorMeta = ModHelper.getMeta("connectormod");
            sb.append(connectorMeta.getName()).append('/').append(connectorMeta.getVersion());
        }
        return sb.toString();
    }

    public static String buildSystemUAString() {
        SystemInfo system = new SystemInfo();
        OperatingSystem os = system.getOperatingSystem();
        String osFamily = os.getFamily();
        String osVersion = os.getVersionInfo().getVersion();
        String bitness = switch (os.getBitness()) {
            case 32 -> "x86";
            case 64 -> "x64";
            default -> throw new IllegalStateException("Unsupported operating system bitness: " + os.getBitness());
        };
        return String.format("%s %s; %s", osFamily, osVersion, bitness);
    }

    public static HttpRequest.Builder acceptsJson(HttpRequest.Builder builder) {
        return builder.header("Accept", "application/json;charset=UTF-8");
    }

    public static HttpRequest.Builder sendsJson(HttpRequest.Builder builder) {
        return builder.header("Content-Type", "application/json;charset=UTF-8");
    }

    public static HttpRequest.Builder addUserAgentHeader(HttpRequest.Builder requestBuilder) {
        return requestBuilder.header("User-Agent", HttpUtil.getUserAgentString());
    }

    public static void postJsonRequest(URI uri, JsonElement json, UnaryOperator<HttpRequest.Builder> extraProperties) {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(uri).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson(json)));
        HttpUtil.sendsJson(requestBuilder);
        HttpUtil.addUserAgentHeader(requestBuilder);
        HttpRequest request = ((HttpRequest.Builder)extraProperties.apply(requestBuilder.timeout(DataSyncMod.REQUEST_TIMEOUT))).build();
        try {
            HttpResponse<Void> response = HttpUtil.getClient().send(request, HttpResponse.BodyHandlers.discarding());
            DataSyncMod.LOGGER.trace("HTTP {}:{} - {}", new Object[]{request.method(), response.statusCode(), request.uri()});
            if (response.statusCode() < 200 || response.statusCode() >= 300) {
                throw new IOException("Unable to send data: received HTTP " + response.statusCode());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("unable to send request", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException("IO error when sending request", e);
        }
    }

    public static JsonElement postJson(URI uri, JsonElement json) {
        JsonElement jsonElement;
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder(uri).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson(json)));
        HttpUtil.sendsJson(requestBuilder);
        HttpUtil.acceptsJson(requestBuilder);
        HttpUtil.addUserAgentHeader(requestBuilder);
        HttpRequest request = requestBuilder.timeout(DataSyncMod.REQUEST_TIMEOUT).build();
        HttpResponse<InputStream> response = HttpUtil.getClient().send(request, HttpResponse.BodyHandlers.ofInputStream());
        DataSyncMod.LOGGER.trace("HTTP {}:{} - {}", new Object[]{request.method(), response.statusCode(), request.uri()});
        if (response.statusCode() < 200 || response.statusCode() >= 300) {
            throw new IOException("Unable to send data: received HTTP " + response.statusCode());
        }
        InputStreamReader reader = new InputStreamReader(response.body(), StandardCharsets.UTF_8);
        try {
            jsonElement = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("unable to send request", e);
            }
            catch (IOException e) {
                throw new UncheckedIOException("IO error when sending request", e);
            }
        }
        reader.close();
        return jsonElement;
    }

    @Nullable
    public static JsonElement makeJsonRequest(HttpRequest.Builder requestBuilder) {
        JsonElement jsonElement;
        HttpUtil.acceptsJson(requestBuilder);
        HttpUtil.addUserAgentHeader(requestBuilder);
        HttpRequest request = requestBuilder.timeout(DataSyncMod.REQUEST_TIMEOUT).build();
        HttpResponse<InputStream> response = HttpUtil.getClient().send(request, HttpResponse.BodyHandlers.ofInputStream());
        DataSyncMod.LOGGER.trace("HTTP {}:{} - {}", new Object[]{request.method(), response.statusCode(), request.uri()});
        if (response.statusCode() < 200 || response.statusCode() >= 300) {
            if (response.statusCode() == 404) {
                return null;
            }
            return null;
        }
        InputStreamReader reader = new InputStreamReader(response.body(), StandardCharsets.UTF_8);
        try {
            jsonElement = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ConnectException e) {
                if (e.getMessage() != null) {
                    DataSyncMod.LOGGER.error("HTTP {} {} - {}", new Object[]{request.method(), request.uri(), e.getMessage()});
                } else {
                    DataSyncMod.LOGGER.error("HTTP {} {} - UNKNOWN ERROR", new Object[]{request.method(), request.uri(), e});
                }
                return null;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("unable to handle request", e);
            }
            catch (IOException e) {
                throw new RuntimeException("IO error when handling request", e);
            }
        }
        reader.close();
        return jsonElement;
    }

    public static String urlEncode(class_2960 id) {
        return id.method_12836() + "/" + id.method_12832();
    }
}

